/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			assign_treatment.do
Description: 	Assign Treatment (and also create new season variable)

Notes: 			- Created by Richard 
				- Last updated 8/24/2022
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab new data  *****************
	use "${finaldata}/final", clear
	
**first, create new season variable that is just the last two digits of the actual season
gen season_last2 = .
replace season_last2 = mod(season,100)
**even easier than I expected

drop if season > 1919
**it looks like the 1920 season was still included for the top four leagues from the last project

gen treatment_season = .
replace treatment_season = 20 if country == "japan"
replace treatment_season = 1920 if country == "scotland"
replace treatment_season = 1920 if country == "denmark"
replace treatment_season = 1920 if country == "premier_league"
replace treatment_season = 1920 if country == "switzerland"
replace treatment_season = 1920 if country == "russia"
replace treatment_season = 1920 if country == "greece"

replace treatment_season = 19 if country == "brazil"
replace treatment_season = 1819 if country == "dutch"
replace treatment_season = 1819 if country == "la_liga"
replace treatment_season = 1819 if country == "france"
replace treatment_season = 1819 if country == "turkey"


replace treatment_season = 1718 if country == "serie_a"
replace treatment_season = 1718 if country == "bundesliga"
replace treatment_season = 1718 if country == "australia"
replace treatment_season = 1718 if country == "portugal"
*replace treatment_season = 17 if country == "korea"


gen treatment_season_last2 = .
replace treatment_season_last2 = mod(treatment_season,100)


gen VAR = 0
replace VAR = 1 if season == treatment_season
replace VAR = 1 if season > treatment_season
*replace VAR = 0 if country == "korea" & season == 17 & wk < 18

	save "${finaldata}/final_treatment", replace	
	