/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			clean_old_leagues.do
Description: 	Makes some slight edits to our old data (just renaming and stuff)

Notes: 			- Created by Jeff 
				- Last updated 8/24/2022
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear

set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"


**************** Grab old data and make it a similar format *****************
	use "${cleandata}/previous_leagues", clear
	
	rename *, lower
	drop homeindicator matchup // need to remake matchup 
	
	encode day, gen(day_num)
	drop day
	rename day_num day
	
	rename team1 home_team
	rename team2 away_team
	rename t1g home_score
	rename t2g away_score
	rename t1xg home_xg
	rename t2xg away_xg
	rename t1gminust2g goal_diff
	rename t1xgminust2xg goal_diff_xg
	
	rename league country // just to match
	
	* Time (note that some matches do not have a start time)
	split time, p("(")
	split time1, p(":")
	rename time11 hour_start
	rename time12 minute_start
	drop time1 time2 time	
	destring hour_start minute_start, replace
	
	compress
	
	save "${cleandata}/previous_leagues_new", replace
	