/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			european_only_nocontrols.do
Description: 	Robustness check using only countries on the European schedule

Notes: 			- Created by Jeff 
				- Last updated 2/06/2024
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables/robustness"

**************** Grab new data  *****************
	use "${finaldata}/final_treatment", clear
	
	

	**gen new variables to ease analysis
	egen countryXweek = group(country wk)
	encode country, gen(country_num)


	**drop Korea, who adopt VAR midseason in 2017
	drop if country == "korea"	
	drop if goal_diff == .
	
	
	
	la var diff_points "Points Diff. (Cumulative)"
	la var recent_points_diff_4 "Points Diff. (Last 4)"
	la var diff_prev_season_points "Points Diff. (Prev. Season)"
	
	
	
	reghdfe goal_diff VAR, absorb(season country_num) cluster(country)
					eststo goal_diff_regular
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
	
	
	reghdfe goal_diff VAR, absorb(season_last2 country_num) cluster(country)
					eststo goal_diff_last2
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					
	gen season_first2 = .
	replace season_first2 = season_last2 - 1 if season > 100
	replace season_first2 = season_last2 if season < 100
	
	
	reghdfe goal_diff VAR, absorb(season_first2 country_num) cluster(country)
					eststo goal_diff_first2
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					
	**drop Brazil and Japan, who play inverted schedule
	drop if country == "brazil"
	drop if country == "japan"
	
	reghdfe goal_diff VAR, absorb(season country_num) cluster(country)
					eststo goal_diff_EuroOnly
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					
					
					
	**** Main Table (home-away goals)
				#delimit  ;
					esttab goal_diff_regular goal_diff_last2 goal_diff_first2 goal_diff_EuroOnly using "$regressions/robustness_EuroSched_nocontrols.tex", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Constant" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	