/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			plot_GD_byleagueseason.do
Description: 	Plot goal difference by each league over time (replicate by region and adoption timing)

Notes: 			- Created by Richard 
				- Last updated 11/30/2022
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
*set scheme plotplainblind
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab new data  *****************
	use "${finaldata}/final_treatment", clear
	/*
	gen season_last2 = .
	replace season_last2 = mod(season,100)
	**even easier than I expected

	drop if season > 1919
	**it looks like the 1920 season was still included for the top four leagues from the last project

	gen treatment_season = .
	replace treatment_season = 20 if country == "japan"
	replace treatment_season = 1920 if country == "scotland"
	replace treatment_season = 1920 if country == "denmark"
	replace treatment_season = 1920 if country == "premier_league"
	replace treatment_season = 1920 if country == "switzerland"
	replace treatment_season = 1920 if country == "russia"
	replace treatment_season = 1920 if country == "greece"

	replace treatment_season = 19 if country == "brazil"
	replace treatment_season = 1819 if country == "dutch"
	replace treatment_season = 1819 if country == "la_liga"
	replace treatment_season = 1819 if country == "france"
	replace treatment_season = 1819 if country == "turkey"


	replace treatment_season = 1718 if country == "serie_a"
	replace treatment_season = 1718 if country == "bundesliga"
	replace treatment_season = 1718 if country == "australia"
	replace treatment_season = 1718 if country == "portugal"
	

	gen treatment_season_last2 = .
	replace treatment_season_last2 = mod(treatment_season,100)

	gen VAR = 0
	replace VAR = 1 if season == treatment_season
	replace VAR = 1 if season > treatment_season
	*/
********************** Create Variables for Reg **************
	collapse (mean) goal_diff treatment_season_last2, by(season_last2 country)
	
	matrix GD = J(10,23,.)
	
	gen eu_status = 0
	**Europe Top 5
	replace eu_status = 1 if country == "premier_league"
	replace eu_status = 1 if country == "serie_a"
	replace eu_status = 1 if country == "la_liga"
	replace eu_status = 1 if country == "bundesliga"
	replace eu_status = 1 if country == "france"
	**Europe Other
	replace eu_status = 2 if country == "turkey"
	replace eu_status = 2 if country == "greece"
	replace eu_status = 2 if country == "russia"
	replace eu_status = 2 if country == "switzerland"
	replace eu_status = 2 if country == "denmark"
	replace eu_status = 2 if country == "scotland"
	replace eu_status = 2 if country == "portugal"
	replace eu_status = 2 if country == "dutch"
	**Non-Europe
	replace eu_status = 3 if country == "australia" 
	replace eu_status = 3 if country == "japan"
	replace eu_status = 3 if country == "brazil"
	
	forvalues k = 10(1)19 {
		sca row = `k' - 9
		matrix GD[row,1] = `k'
		quietly sum goal_diff if season_last2 == `k' & country == "premier_league"
		matrix GD[row,2] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "bundesliga"
		matrix GD[row,3] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "serie_a"
		matrix GD[row,4] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "la_liga"
		matrix GD[row,5] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "dutch"
		matrix GD[row,6] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "brazil"
		matrix GD[row,7] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "japan"
		matrix GD[row,8] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "australia"
		matrix GD[row,9] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "portugal"
		matrix GD[row,10] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "scotland"
		matrix GD[row,11] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "denmark"
		matrix GD[row,12] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "france"
		matrix GD[row,13] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "russia"
		matrix GD[row,14] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "switzerland"
		matrix GD[row,15] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "greece"
		matrix GD[row,16] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & country == "turkey"
		matrix GD[row,17] = r(mean)
		
		quietly sum goal_diff if season_last2 == `k' & treatment_season_last2 == 18
		matrix GD[row,18] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & treatment_season_last2 == 19
		matrix GD[row,19] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & treatment_season_last2 > 19
		matrix GD[row,20] = r(mean)
		
		quietly sum goal_diff if season_last2 == `k' & eu_status == 1
		matrix GD[row,21] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & eu_status == 2
		matrix GD[row,22] = r(mean)
		quietly sum goal_diff if season_last2 == `k' & eu_status == 3
		matrix GD[row,23] = r(mean)
}

matrix list GD
drop _all

set obs 10
gen season = _n + 9
gen england = 0
gen spain = 0
gen germany = 0
gen italy = 0
gen netherlands = 0
gen brazil = 0
gen japan = 0
gen australia = 0
gen portugal = 0
gen scotland = 0
gen denmark = 0
gen france = 0
gen russia = 0
gen switzerland = 0
gen greece = 0
gen turkey = 0

gen early = 0
gen late = 0
gen never = 0

gen eu_top5 = 0
gen eu_other = 0
gen non_eu = 0


forvalues i = 1(1)10{
	replace england = GD[`i',2] if _n == `i'
	replace germany = GD[`i',3] if _n == `i'
	replace italy = GD[`i',4] if _n == `i'
	replace spain = GD[`i',5] if _n == `i'
	replace netherlands = GD[`i',6] if _n == `i'
	replace brazil = GD[`i',7] if _n == `i'
	replace japan = GD[`i',8] if _n == `i'
	replace australia = GD[`i',9] if _n == `i'
	replace portugal = GD[`i',10] if _n == `i'
	replace scotland = GD[`i',11] if _n == `i'
	replace denmark = GD[`i',12] if _n == `i'
	replace france = GD[`i',13] if _n == `i'
	replace russia = GD[`i',14] if _n == `i'
	replace switzerland = GD[`i',15] if _n == `i'
	replace greece = GD[`i',16] if _n == `i'
	replace turkey = GD[`i',17] if _n == `i'
	
	replace early = GD[`i',18] if _n == `i'
	replace late = GD[`i',19] if _n == `i'
	replace never = GD[`i',20] if _n == `i'
	
	replace eu_top5 = GD[`i',21] if _n == `i'
	replace eu_other = GD[`i',22] if _n == `i'
	replace non_eu = GD[`i',23] if _n == `i'
}
	
	**make background white
	**fix y axis to 0 through 1
	
	tsset season
	graph twoway tsline england germany italy spain netherlands brazil japan australia portugal scotland denmark france russia switzerland greece turkey, ytitle("Goal Difference") xtitle("Season") ylabel(0(0.2)1) plotregion(fcolor(white)) graphregion(fcolor(white))
	gr export "${graphs}/GD_byseason_league.png", replace
	
	tsset season
	graph twoway tsline early late never, ytitle("Goal Difference") lcolor(black blue red) legend(order(1 "Early" 2 "Late" 3 "Never" )) xtitle("Season") ylabel(0(0.2)1) plotregion(fcolor(white)) graphregion(fcolor(white))
	gr export "${graphs}/GD_byseason_adoption.png", replace
	
	tsset season
	graph twoway tsline eu_top5 eu_other non_eu, legend(order(1 "European Top 5 Leagues" 2 "European Other Leagues" 3 "Non-European Leagues" )) ytitle("Goal Difference") xtitle("Season") ylabel(0(0.2)1) plotregion(fcolor(white)) graphregion(fcolor(white))
	gr export "${graphs}/GD_byseason_region.png", replace