/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			preliminary_tables_wrefs_experience.do
Description: 	Preliminary analysis wrefs_experience tables

Notes: 			- Created by Jeff, copied by Camilo
				- Last updated 9/13/2022
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"


* Raw data
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables/progresive_controls"

**************** Grab new data  *****************
	use "${finaldata}/final_treatment_wrefs_experience", clear
	
	**gen new variables to ease analysis
	egen countryXweek = group(country wk)
	encode country, gen(country_num)


	**drop Korea, who adopt VAR midseason in 2017
	drop if country == "korea"	
	
	la var diff_points "Points Diff. \\ (Cumulative)"
	la var recent_points_diff_4 "Points Diff. \\ (Last 4)"
	la var diff_prev_season_points "Points Diff. \\ (Prev. Season)"
	la var experienced_ref "International ref"
	la var apps_overall "$\#$ appereances ref"
	la var ref_yellow_dif "$\Delta$ yellow (h-a), \\ p-game-ref"
	la var ref_red_dif "$\Delta$ red (h-a), \\ p-game-ref"
		
	*We start with results that are going to be stored in the prefered_spec folder:
    *What we do here is progresively add referee controls to Jeff's team strenghts controls!
		
local loop "goal_diff goal_diff_xg win draw home_points total_goals total_xgoals"
	
	local team_stregth_controls "diff_points recent_points_diff_4 diff_prev_season_points"
	
	local ref_controls "apps_overall experienced_ref ref_yellow_dif ref_red_dif"
	
	local all_controls "diff_points recent_points_diff_4 diff_prev_season_points apps_overall experienced_ref ref_yellow_dif ref_red_dif"
	
	foreach l of local loop {
		/*
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}
			*/
	
	reghdfe `l' VAR, noabsorb cluster(country) // 
					eststo `l'_none
					estadd local team_stregth_controls "No" , replace
					estadd local ref_controls "No" , replace
					estadd local season "No" , replace
					estadd local country "No" , replace

	reghdfe `l' VAR, absorb(i.season i.country_num) cluster(country) // absorbs season and country
					eststo `l'_fx
					estadd local team_stregth_controls "No" , replace
					estadd local ref_controls "No" , replace
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace
					
	reghdfe `l' VAR `team_stregth_controls', absorb(i.season i.country_num) cluster(country) // 
					eststo `l'_fx_control1
					estadd local team_stregth_controls "Yes" , replace
					estadd local ref_controls "No" , replace
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace
					
	reghdfe `l' VAR `ref_controls', absorb(i.season i.country_num) cluster(country) // 
					eststo `l'_fx_control2
					estadd local team_stregth_controls "No" , replace
					estadd local ref_controls "Yes" , replace
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace
					
					
	reghdfe `l' VAR `all_controls', absorb(i.season i.country_num) cluster(country) // 
					eststo `l'_fx_control3
					estadd local team_stregth_controls "Yes" , replace
					estadd local ref_controls "Yes" , replace
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace

					

		}
		
		
		
		**** Main Table (home-away goals)
				#delimit  ;
					esttab goal_diff_none goal_diff_fx goal_diff_fx_control1 goal_diff_fx_control2 goal_diff_fx_control3 using "$regressions/prefered_spec/home_minus_away_goals", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `all_controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{0.2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(team_stregth_controls ref_controls season country N N_clust, 
							labels("Team Controls" "Ref Controls" "Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
					
		**** Second Main Table (home-away xgoals)
				#delimit  ;
					esttab goal_diff_xg_none goal_diff_xg_fx goal_diff_xg_fx_control1 goal_diff_xg_fx_control2 goal_diff_xg_fx_control3 using "$regressions/prefered_spec/home_minus_away_xgoals", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$xG\_{H-A}\$" "\$xG\_{H-A}\$" "\$xG\_{H-A}\$" "\$xG\_{H-A}\$" "\$xG\_{H-A}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `all_controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{1pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(team_stregth_controls ref_controls season country N N_clust, 
							labels("Team Controls" "Ref Controls" "Season FE" "League FE" "Observations" "Clusters")  
							fmt(%9.0fc %9.0fc));
					#delimit cr		
					
		**** Third Main Table (home points)
				#delimit  ;
					esttab home_points_none home_points_fx home_points_fx_control1 home_points_fx_control2 home_points_fx_control3 using "$regressions/prefered_spec/home_points", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Home Points" "Home Points" "Home Points" "Home Points" "Home Points") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `all_controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{1pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(team_stregth_controls ref_controls season country N N_clust, 
							labels("Team Controls" "Ref Controls" "Season FE" "League FE" "Observations" "Clusters")  
							fmt(%9.0fc %9.0fc));
					#delimit cr							
					
		
		
		**** Appendix Table (total goals)
				#delimit  ;
					esttab total_goals_none total_goals_fx total_goals_fx_control1 total_goals_fx_control2 total_goals_fx_control3 using "$regressions/prefered_spec/total", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{total}\$" "\$G\_{total}\$" "\$G\_{total}\$" "\$G\_{total}\$" "\$G\_{total}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `all_controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{1pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(team_stregth_controls ref_controls season country N N_clust, 
							labels("Team Controls" "Ref Controls" "Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
		**** Appendix Table (win)
				#delimit  ;
					esttab win_none win_fx win_fx_control1 win_fx_control2 win_fx_control3 using "$regressions/prefered_spec/game_outcomes_win", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Win" "Win" "Win" "Win" "Win") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `all_controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{1pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(team_stregth_controls ref_controls season country N N_clust, 
							labels("Team Controls" "Ref Controls" "Season FE" "League FE" "Observations" "Clusters")  
							fmt(%9.0fc %9.0fc));
					#delimit cr						
					
		**** Appendix Table (draw)
				#delimit  ;
					esttab draw_none draw_fx draw_fx_control1 draw_fx_control2 draw_fx_control3 using "$regressions/prefered_spec/game_outcomes_draw", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Draw" "Draw" "Draw" "Draw" "Draw") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `all_controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{1pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(team_stregth_controls ref_controls season country N N_clust, 
							labels("Team Controls" "Ref Controls" "Season FE" "League FE" "Observations" "Clusters")
							fmt(%9.0fc %9.0fc));
					#delimit cr						
					
		estimates clear	
		
		
******************** Robust Standard Errors *********************************
local loop "goal_diff goal_diff_xg win draw home_points total_goals total_xgoals"
	
	local team_stregth_controls "diff_points recent_points_diff_4 diff_prev_season_points"
	
	local ref_controls "apps_overall experienced_ref ref_yellow_dif ref_red_dif"
	
	local all_controls "diff_points recent_points_diff_4 diff_prev_season_points apps_overall experienced_ref ref_yellow_dif ref_red_dif"
		
	foreach l of local loop {
		
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}
			
	
	reghdfe `l' VAR, noabsorb vce(robust) // 
					eststo `l'_none
					estadd local team_stregth_controls "No" , replace
					estadd local ref_controls "No" , replace
					estadd local season "No" , replace
					estadd local country "No" , replace

	reghdfe `l' VAR, absorb(i.season i.country_num) vce(robust) // absorbs season and country
					eststo `l'_fx
					estadd local team_stregth_controls "No" , replace
					estadd local ref_controls "No" , replace
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace
					
	reghdfe `l' VAR `team_stregth_controls', absorb(i.season i.country_num) vce(robust) // include 1st control
					eststo `l'_fx_control1
					estadd local team_stregth_controls "Yes" , replace
					estadd local ref_controls "No" , replace
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace
					
					
					
	reghdfe `l' VAR `ref_controls', absorb(i.season i.country_num) vce(robust) // include + controls
					eststo `l'_fx_control2
					estadd local team_stregth_controls "No" , replace
					estadd local ref_controls "Yes" , replace
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace
					
					
	reghdfe `l' VAR `all_controls', absorb(i.season i.country_num) vce(robust) // include + controls
					eststo `l'_fx_control3
					estadd local team_stregth_controls "Yes" , replace
					estadd local ref_controls "Yes" , replace
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace

					

		}
		
		
		
		**** Main Table (home-away goals)
				#delimit  ;
					esttab goal_diff_none goal_diff_fx goal_diff_fx_control1 goal_diff_fx_control2 goal_diff_fx_control3 using "$regressions/prefered_spec/home_minus_away_goals_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `all_controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{0.2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(team_stregth_controls ref_controls season country N, 
							labels("Team Controls" "Ref Controls" "Season FE" "League FE" "Observations") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
					
		**** Second Main Table (home-away xgoals)
				#delimit  ;
					esttab goal_diff_xg_none goal_diff_xg_fx goal_diff_xg_fx_control1 goal_diff_xg_fx_control2 goal_diff_xg_fx_control3 using "$regressions/prefered_spec/home_minus_away_xgoals_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$xG\_{H-A}\$" "\$xG\_{H-A}\$" "\$xG\_{H-A}\$" "\$xG\_{H-A}\$" "\$xG\_{H-A}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `all_controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{1pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(team_stregth_controls ref_controls season country N, 
							labels("Team Controls" "Ref Controls" "Season FE" "League FE" "Observations")
							fmt(%9.0fc %9.0fc));
					#delimit cr		
					
		**** Third Main Table (home points)
				#delimit  ;
					esttab home_points_none home_points_fx home_points_fx_control1 home_points_fx_control2 home_points_fx_control3 using "$regressions/prefered_spec/home_points_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Home Points" "Home Points" "Home Points" "Home Points" "Home Points") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `all_controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{1pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(team_stregth_controls ref_controls season country N, 
							labels("Team Controls" "Ref Controls" "Season FE" "League FE" "Observations")
							fmt(%9.0fc %9.0fc));
					#delimit cr							
					
		
		
		**** Appendix Table (total goals)
				#delimit  ;
					esttab total_goals_none total_goals_fx total_goals_fx_control1 total_goals_fx_control2 total_goals_fx_control3 using "$regressions/prefered_spec/total_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{total}\$" "\$G\_{total}\$" "\$G\_{total}\$" "\$G\_{total}\$" "\$G\_{total}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `all_controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{1pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(team_stregth_controls ref_controls season country N, 
							labels("Team Controls" "Ref Controls" "Season FE" "League FE" "Observations")
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
		**** Appendix Table (win)
				#delimit  ;
					esttab win_none win_fx win_fx_control1 win_fx_control2 win_fx_control3 using "$regressions/prefered_spec/game_outcomes_win_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Win" "Win" "Win" "Win" "Win") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `all_controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{1pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(team_stregth_controls ref_controls season country N, 
							labels("Team Controls" "Ref Controls" "Season FE" "League FE" "Observations")
							fmt(%9.0fc %9.0fc));
					#delimit cr						
					
		**** Appendix Table (draw)
				#delimit  ;
					esttab draw_none draw_fx draw_fx_control1 draw_fx_control2 draw_fx_control3 using "$regressions/prefered_spec/game_outcomes_draw_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Draw" "Draw" "Draw" "Draw" "Draw") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `all_controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{1pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(team_stregth_controls ref_controls season country N, 
							labels("Team Controls" "Ref Controls" "Season FE" "League FE" "Observations") 
							fmt(%9.0fc %9.0fc));
					#delimit cr						
					
		estimates clear	

