/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			preliminary_tables_country.do
Description: 	Preliminary analysis tables with the analysis at the country level

Notes: 			- Created by Jeff 
				- Last updated 9/28/2023
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab new data  *****************
	use "${finaldata}/final_treatment", clear
	
	

	**gen new variables to ease analysis
	egen countryXweek = group(country wk)
	encode country, gen(country_num)


	**drop Korea, who adopt VAR midseason in 2017
	drop if country == "korea"	
	drop if goal_diff == .
	
	la var diff_points "Points Diff. (Cumulative)"
	la var recent_points_diff_4 "Points Diff. (Last 4)"
	la var diff_prev_season_points "Points Diff. (Prev. Season)"

	collapse (mean) goal_diff goal_diff_xg win draw home_points total_goals total_xgoals VAR country_num, by(country season)
	
local loop "goal_diff goal_diff_xg win draw home_points total_goals total_xgoals"
	foreach l of local loop {
	/*
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}
			*/
					
	reghdfe `l' VAR `controls', absorb(i.season i.country_num) cluster(country) // controls for "form" and season/country
					eststo `l'_all
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace	
								
										
			
		}
		
		
		
		**** Main Table (All the main HFA outcomes)
				#delimit  ;
					esttab goal_diff_all win_all draw_all home_points_all using "$regressions/diff-in-diff/country_hfa", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{H-A}\$" "Win" "Draw" "Points") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _) 
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR) 
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{l*{5}{c}}  \midrule ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
						#delimit cr	
					
					
		**** Second Table (Total and total xgoals)
				#delimit  ;
					esttab total_goals_all total_xgoals_all using "$regressions/diff-in-diff/country_total", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{total}\$" "\$xG\_{total}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{l*{3}{c}}  \midrule ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr		
					

		estimates clear	
		
		
******************** Robust Standard Errors *********************************
local loop "goal_diff goal_diff_xg win draw home_points total_goals total_xgoals"
	foreach l of local loop {
	
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}

					
	reghdfe `l' VAR, absorb(i.season i.country_num) vce(robust) // controls for "form"
					eststo `l'_all
					estadd local controls "Yes" , replace
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace				
										
			
		}
		
		
		**** Main Table (All the main HFA outcomes)
				#delimit  ;
					esttab goal_diff_all win_all draw_all home_points_all using "$regressions/diff-in-diff/country_hfa_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{H-A}\$" "Win" "Draw" "Points") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{l*{5}{c}}  \midrule ") 
							stats(season country N, 
							labels("Season FE" "League FE" "Observations") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
					
		**** Second Table (Total and total xgoals)
				#delimit  ;
					esttab total_goals_all total_xgoals_all using "$regressions/diff-in-diff/country_total_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{total}\$" "\$xG\_{total}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{l*{3}{c}}  \midrule ") 
							stats(season country N, 
							labels("Season FE" "League FE" "Observations") 
							fmt(%9.0fc %9.0fc));
					#delimit cr		
					

		estimates clear			