/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			preliminary_tables_refxp_nocontrols.do
Description: 	Analysis tables for only referees with high experience

Notes: 			- Created by Jeff, adapted by Richard
				- Last updated 11/30/2022
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab new data  *****************
	use "${finaldata}/final_treatment_wrefs_experience", clear
	

	**gen new variables to ease analysis
	egen countryXweek = group(country wk)
	encode country, gen(country_num)


	**drop Korea, who adopt VAR midseason in 2017
	drop if country == "korea"	
	drop if goal_diff == .
	
	la var diff_points "Points Diff. (Cumulative)"
	la var recent_points_diff_4 "Points Diff. (Last 4)"
	la var diff_prev_season_points "Points Diff. (Prev. Season)"

local loop "goal_diff " /*goal_diff_xg win draw home_points total_goals total_xgoals" */
	local controls "diff_points recent_points_diff_4 diff_prev_season_points"
	foreach l of local loop {
	
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			/*
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}
			*/
/*
	reghdfe `l' VAR, noabsorb cluster(country) // 
					eststo `l'_none
					estadd local controls "No" , replace
					estadd local season "No" , replace
					estadd local country "No" , replace

	reghdfe `l' VAR, absorb(i.season i.country_num) cluster(country) // absorbs season and country
					eststo `l'_fixed
					estadd local controls "No" , replace
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace

					
	reghdfe `l' VAR `controls', noabsorb cluster(country) // controls for points diff
					eststo `l'_strength
					estadd local controls "Yes" , replace
					estadd local season "No" , replace
					estadd local country "No" , replace
*/
					
	reghdfe `l' VAR, absorb(i.season i.country_num) cluster(country) // controls for "form" and season/country
					eststo `l'_allxp
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					
	reghdfe `l' VAR if experienced_ref == 1, absorb(i.season i.country_num) cluster(country) // controls for "form" and season/country
					eststo `l'_highxp
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					
	reghdfe `l' VAR if experienced_ref == 0, absorb(i.season i.country_num) cluster(country) // controls for "form" and season/country
					eststo `l'_lowxp
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
								
										
			
		}
		
		
		
		**** Main Table (home-away goals)
				#delimit  ;
					esttab goal_diff_allxp goal_diff_highxp goal_diff_lowxp using "$regressions/refxp/home_minus_away_goals_refxp_nocontrols", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Constant" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country N N_clust, 
							labels("Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					/*