/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			preliminary_tables_season_FE.do
Description: 	Preliminary analysis tables but now with just Season FEs that are common to all leagues

Notes: 			- Created by Jeff 
				- Last updated 10/17/2022
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab new data  *****************
	use "${finaldata}/final_treatment", clear
	
	

	**gen new variables to ease analysis
	egen countryXweek = group(country wk)
	encode country, gen(country_num)


	**drop Korea, who adopt VAR midseason in 2017
	drop if country == "korea"	
	drop if goal_diff == .
	
	la var diff_points "Points Diff. (Cumulative)"
	la var recent_points_diff_4 "Points Diff. (Last 4)"
	la var diff_prev_season_points "Points Diff. (Prev. Season)"

local loop "goal_diff goal_diff_xg win draw home_points total_goals total_xgoals"
	local controls "diff_points recent_points_diff_4 diff_prev_season_points"
	foreach l of local loop {
	/*
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}
			*/

	reghdfe `l' VAR, noabsorb cluster(country) // 
					eststo `l'_none
					estadd local controls "No" , replace
					estadd local season "No" , replace
					estadd local country "No" , replace

	reghdfe `l' VAR, absorb(i.season_last2 i.country_num) cluster(country) // absorbs season and country
					eststo `l'_fixed
					estadd local controls "No" , replace
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace

					
	reghdfe `l' VAR `controls', noabsorb cluster(country) // controls for points diff
					eststo `l'_strength
					estadd local controls "Yes" , replace
					estadd local season "No" , replace
					estadd local country "No" , replace

					
	reghdfe `l' VAR `controls', absorb(i.season_last2 i.country_num) cluster(country) // controls for "form" and season/country
					eststo `l'_all
					estadd local controls "Yes" , replace
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace	
								
										
			
		}
		
		
		
		**** Main Table (home-away goals)
				#delimit  ;
					esttab goal_diff_none goal_diff_fixed goal_diff_strength goal_diff_all using "$regressions/diff-in-diff/home_minus_away_goals_last2", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(controls season country N N_clust, 
							labels("General Controls" "Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
					
		**** Second Main Table (home-away xgoals)
				#delimit  ;
					esttab goal_diff_xg_none goal_diff_xg_fixed goal_diff_xg_strength goal_diff_xg_all using "$regressions/diff-in-diff/home_minus_away_xgoals_last2", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$xG\_{H-A}\$" "\$xG\_{H-A}\$" "\$xG\_{H-A}\$" "\$xG\_{H-A}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(controls season country N N_clust, 
							labels("General Controls" "Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr		
					
		**** Third Main Table (home points)
				#delimit  ;
					esttab home_points_none home_points_fixed home_points_strength home_points_all using "$regressions/diff-in-diff/home_points_last2", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Home Points" "Home Points" "Home Points" "Home Points") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(controls season country N N_clust, 
							labels("General Controls" "Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr							
					
		**** Appendix Table (total goals)
				#delimit  ;
					esttab total_goals_none total_goals_all total_xgoals_none total_xgoals_all using "$regressions/diff-in-diff/total_last2", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{total}\$" "\$G\_{total}\$" "\$xG\_{total}\$" "\$xG\_{total}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(controls season country N N_clust, 
							labels("General Controls" "Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
		**** Appendix Table (win/draw)
				#delimit  ;
					esttab win_none win_all draw_none draw_all using "$regressions/diff-in-diff/game_outcomes_last2", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Win" "Win" "Draw" "Draw") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(controls season country N N_clust, 
							labels("General Controls" "Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr						
					
		estimates clear	
		
		
******************** Robust Standard Errors *********************************
local loop "goal_diff goal_diff_xg win draw home_points total_goals total_xgoals"
	local controls "diff_points recent_points_diff_4 diff_prev_season_points"
	foreach l of local loop {
	
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}

	reghdfe `l' VAR, noabsorb vce(robust) // identical to homeindicator+constant
					eststo `l'_none
					estadd local controls "No" , replace
					estadd local season "No" , replace
					estadd local country "No" , replace

	reghdfe `l' VAR, absorb(i.season_last2 i.country_num) vce(robust) // absorbs week and league
					eststo `l'_fixed
					estadd local controls "No" , replace
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace

					
	reghdfe `l' VAR `controls', noabsorb vce(robust) // controls for points diff
					eststo `l'_strength
					estadd local controls "Yes" , replace
					estadd local season "No" , replace
					estadd local country "No" , replace

					
	reghdfe `l' VAR `controls', absorb(i.season_last2 i.country_num) vce(robust) // controls for "form"
					eststo `l'_all
					estadd local controls "Yes" , replace
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace				
										
			
		}
		
		
		**** Main Table (home-away goals)
				#delimit  ;
					esttab goal_diff_none goal_diff_fixed goal_diff_strength goal_diff_all using "$regressions/diff-in-diff/home_minus_away_goals_last2_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(controls season country N, 
							labels("General Controls" "Season FE" "League FE" "Observations") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
		**** Second Main Table (home-away xgoals)
				#delimit  ;
					esttab goal_diff_xg_none goal_diff_xg_fixed goal_diff_xg_strength goal_diff_xg_all using "$regressions/diff-in-diff/home_minus_away_xgoals_last2_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$xG\_{H-A}\$" "\$xG\_{H-A}\$" "\$xG\_{H-A}\$" "\$xG\_{H-A}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(controls season country N, 
							labels("General Controls" "Season FE" "League FE" "Observations") 
							fmt(%9.0fc %9.0fc));
					#delimit cr		
					
		**** Third Main Table (home points)
				#delimit  ;
					esttab home_points_none home_points_fixed home_points_strength home_points_all using "$regressions/diff-in-diff/home_points_last2_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Home Points" "Home Points" "Home Points" "Home Points") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(controls season country N N_clust, 
							labels("General Controls" "Season FE" "League FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr						
					
		**** Appendix Table (total goals)
				#delimit  ;
					esttab total_goals_none total_goals_all total_xgoals_none total_xgoals_all using "$regressions/diff-in-diff/total_last2_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{total}\$" "\$G\_{total}\$" "\$xG\_{total}\$" "\$xG\_{total}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(controls season country N, 
							labels("General Controls" "Season FE" "League FE" "Observations") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
		**** Appendix Table (win/draw)
				#delimit  ;
					esttab win_none win_all draw_none draw_all using "$regressions/diff-in-diff/game_outcomes_last2_robust_se", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Win" "Win" "Draw" "Draw") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR `controls') substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(controls season country N, 
							labels("General Controls" "Season FE" "League FE" "Observations") 
							fmt(%9.0fc %9.0fc));
					#delimit cr						
					
		estimates clear		