/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			preliminary.do
Description: 	Preliminary analysis, with refs data, including dummy for experience

Notes: 			- Created by Camilo
				- Last updated 9/27/2022
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab data with refs and experience  *****************
	use "${finaldata}/final_treatment_wrefs_experience", clear
	
**gen new variables to ease analysis
egen countryXweek = group(country wk)


**drop Korea, who adopt VAR midseason in 2017
drop if country == "korea"	


** Let's include several refs variables to the regressions previously ran
*Check the variables we have at hand:
ds

* I'm replicating what we have in the preliminary do file, but including some of the aforementioned covariates

e

reg goal_diff VAR apps_overall

reg goal_diff VAR ref_pen_dif

* sign do not make sense, the more penalties ref give to home team
* the smaller the goal diff ?

reg goal_diff VAR ref_yellow_dif

reg goal_diff VAR ref_red_dif

* these last two do make sense, the more yellow/reds a ref gives to the home team, the smaller the goal_diff

reg goal_diff VAR experienced_ref

reg goal_diff VAR experienced_ref var_ref


**check if clusters affect inference
reghdfe goal_diff VAR apps_overall, noabsorb cluster(country)
reghdfe goal_diff VAR ref_pen_dif, noabsorb cluster(country)
reghdfe goal_diff VAR ref_yellow_dif, noabsorb cluster(country)
reghdfe goal_diff VAR ref_red_dif, noabsorb cluster(country)
reghdfe goal_diff VAR experienced_ref, noabsorb cluster(country)
reghdfe goal_diff VAR experienced_ref var_ref, noabsorb cluster(country)

**add in country fixed effects
reghdfe goal_diff VAR apps_overall, absorb(country) cluster(country)
reghdfe goal_diff VAR ref_pen_dif, absorb(country) cluster(country)
reghdfe goal_diff VAR ref_yellow_dif, absorb(country) cluster(country)
reghdfe goal_diff VAR ref_red_dif, absorb(country) cluster(country)
reghdfe goal_diff VAR experienced_ref, absorb(country) cluster(country)
reghdfe goal_diff VAR experienced_ref var_ref, absorb(country) cluster(country)

**slightly more flexible country-by-weeks fixed effects
reghdfe goal_diff VAR apps_overall, absorb(countryXweek) cluster(country)
reghdfe goal_diff VAR ref_pen_dif, absorb(countryXweek) cluster(country)
reghdfe goal_diff VAR ref_yellow_dif, absorb(countryXweek) cluster(country)
reghdfe goal_diff VAR ref_red_dif, absorb(countryXweek) cluster(country)
reghdfe goal_diff VAR experienced_ref, absorb(countryXweek) cluster(country)
reghdfe goal_diff VAR experienced_ref var_ref, absorb(countryXweek) cluster(country)


**season fixed effects instead of country fixed effects
reghdfe goal_diff VAR apps_overall, absorb(season) cluster(country)
reghdfe goal_diff VAR ref_pen_dif, absorb(season) cluster(country)
reghdfe goal_diff VAR ref_yellow_dif, absorb(season) cluster(country)
reghdfe goal_diff VAR ref_red_dif, absorb(season) cluster(country)
reghdfe goal_diff VAR experienced_ref, absorb(season) cluster(country)
reghdfe goal_diff VAR experienced_ref var_ref, absorb(season) cluster(country)


**both season fixed effects and country fixed effects
reghdfe goal_diff VAR apps_overall, absorb(season country) cluster(country)
reghdfe goal_diff VAR ref_pen_dif, absorb(season country) cluster(country)
reghdfe goal_diff VAR ref_yellow_dif, absorb(season country) cluster(country)
reghdfe goal_diff VAR ref_red_dif, absorb(season country) cluster(country)
reghdfe goal_diff VAR experienced_ref, absorb(season country) cluster(country)
reghdfe goal_diff VAR experienced_ref var_ref, absorb(season country) cluster(country)

**slightly more flexible country-by-weeks fixed effects
reghdfe goal_diff VAR apps_overall, absorb(season countryXweek) cluster(country)
reghdfe goal_diff VAR ref_pen_dif, absorb(season countryXweek) cluster(country)
reghdfe goal_diff VAR ref_yellow_dif, absorb(season countryXweek) cluster(country)
reghdfe goal_diff VAR ref_red_dif, absorb(season countryXweek) cluster(country)
reghdfe goal_diff VAR experienced_ref, absorb(season countryXweek) cluster(country)
reghdfe goal_diff VAR experienced_ref var_ref, absorb(season countryXweek) cluster(country)

**including all the team-quality controls
reghdfe goal_diff VAR apps_overall past_points_home past_points_away recent_points_home_4 recent_points_away_4 recent_points_home_8 recent_points_away_8 prev_season_points_home prev_season_points_away diff_points recent_points_diff_4 recent_points_diff_8 better_home, absorb(season countryXweek) cluster(country)

reghdfe goal_diff VAR ref_pen_dif past_points_home past_points_away recent_points_home_4 recent_points_away_4 recent_points_home_8 recent_points_away_8 prev_season_points_home prev_season_points_away diff_points recent_points_diff_4 recent_points_diff_8 better_home, absorb(season countryXweek) cluster(country)

reghdfe goal_diff VAR ref_yellow_dif past_points_home past_points_away recent_points_home_4 recent_points_away_4 recent_points_home_8 recent_points_away_8 prev_season_points_home prev_season_points_away diff_points recent_points_diff_4 recent_points_diff_8 better_home, absorb(season countryXweek) cluster(country)

reghdfe goal_diff VAR ref_red_dif past_points_home past_points_away recent_points_home_4 recent_points_away_4 recent_points_home_8 recent_points_away_8 prev_season_points_home prev_season_points_away diff_points recent_points_diff_4 recent_points_diff_8 better_home, absorb(season countryXweek) cluster(country)

reghdfe goal_diff VAR experienced_ref past_points_home past_points_away recent_points_home_4 recent_points_away_4 recent_points_home_8 recent_points_away_8 prev_season_points_home prev_season_points_away diff_points recent_points_diff_4 recent_points_diff_8 better_home, absorb(season countryXweek) cluster(country)

reghdfe goal_diff VAR experienced_ref var_ref past_points_home past_points_away recent_points_home_4 recent_points_away_4 recent_points_home_8 recent_points_away_8 prev_season_points_home prev_season_points_away diff_points recent_points_diff_4 recent_points_diff_8 better_home, absorb(season countryXweek) cluster(country)

**including all the team-quality controls, no better_home here:
reghdfe goal_diff VAR apps_overall past_points_home past_points_away recent_points_home_4 recent_points_away_4 recent_points_home_8 recent_points_away_8 prev_season_points_home prev_season_points_away diff_points recent_points_diff_4 recent_points_diff_8, absorb(season countryXweek) cluster(country)

reghdfe goal_diff VAR ref_pen_dif past_points_home past_points_away recent_points_home_4 recent_points_away_4 recent_points_home_8 recent_points_away_8 prev_season_points_home prev_season_points_away diff_points recent_points_diff_4 recent_points_diff_8, absorb(season countryXweek) cluster(country)

reghdfe goal_diff VAR ref_yellow_dif past_points_home past_points_away recent_points_home_4 recent_points_away_4 recent_points_home_8 recent_points_away_8 prev_season_points_home prev_season_points_away diff_points recent_points_diff_4 recent_points_diff_8, absorb(season countryXweek) cluster(country)

reghdfe goal_diff VAR ref_red_dif past_points_home past_points_away recent_points_home_4 recent_points_away_4 recent_points_home_8 recent_points_away_8 prev_season_points_home prev_season_points_away diff_points recent_points_diff_4 recent_points_diff_8, absorb(season countryXweek) cluster(country)

reghdfe goal_diff VAR experienced_ref past_points_home past_points_away recent_points_home_4 recent_points_away_4 recent_points_home_8 recent_points_away_8 prev_season_points_home prev_season_points_away diff_points recent_points_diff_4 recent_points_diff_8, absorb(season countryXweek) cluster(country)

reghdfe goal_diff VAR experienced_ref var_ref past_points_home past_points_away recent_points_home_4 recent_points_away_4 recent_points_home_8 recent_points_away_8 prev_season_points_home prev_season_points_away diff_points recent_points_diff_4 recent_points_diff_8, absorb(season countryXweek) cluster(country)

*End of this script

