/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			robustness_tables.do
Description: 	Robustness check analysis tables

Notes: 			- Created by Jeff 
				- Last updated 11/10/2023
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab new data  *****************
	use "${finaldata}/final_treatment", clear
	
	

	**gen new variables to ease analysis
	egen countryXweek = group(country wk)
	encode country, gen(country_num)


	**drop Korea, who adopt VAR midseason in 2017
	drop if country == "korea"	
	drop if goal_diff == .
	
	la var diff_points "Points Diff. (Cumulative)"
	la var recent_points_diff_4 "Points Diff. (Last 4)"
	la var diff_prev_season_points "Points Diff. (Prev. Season)"
	
	* Encoding Home Team *
	encode home_team, gen(home_num)
	
	* Encoding Home*Away Team *
	egen homeaway = concat(home_team away_team)
	encode homeaway, gen(homeaway_num)
		
	* Encode Referee *
	encode referee, gen(ref_num)

local loop "goal_diff goal_diff_xg win draw home_points total_goals total_xgoals"
	local controls "diff_points recent_points_diff_4 diff_prev_season_points"
	foreach l of local loop {
	/*
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}
			*/
					
	reghdfe `l' VAR `controls', absorb(i.season i.country_num i.home_num) cluster(country) // controls for "form" and season/country
					eststo `l'_all
					estadd local controls "Yes" , replace
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					estadd local home "Yes", replace
								
	reghdfe `l' VAR `controls', absorb(i.season i.country_num i.homeaway_num) cluster(country) // controls for "form" and season/country
					eststo `l'_all_2
					estadd local controls "Yes" , replace
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					estadd local homeaway "Yes", replace
					
	reghdfe `l' VAR `controls', absorb(i.season i.country_num i.ref_num) cluster(country) // controls for "form" and season/country
					eststo `l'_all_3
					estadd local controls "Yes" , replace
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					estadd local ref "Yes", replace		
							
		}
		
		
************* Home Team FE Results *******************		
	#delimit  ;
					esttab goal_diff_all win_all draw_all home_points_all using "$regressions/diff-in-diff/match_hfa_homeFE", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{H-A}\$" "Win" "Draw" "Points") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _) 
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR) 
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{l*{5}{c}}  \midrule ") 
							stats(season country controls home N N_clust, 
							labels("Season FE" "League FE" "Controls" "Home team FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
						#delimit cr	
					
					
		**** Second Table (Total and total xgoals)
				#delimit  ;
					esttab total_goals_all total_xgoals_all using "$regressions/diff-in-diff/match_total_homeFE", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{total}\$" "\$xG\_{total}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{l*{3}{c}}  \midrule ") 
							stats(season country controls home N N_clust, 
							labels("Season FE" "League FE" "Controls" "Home team FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr		
					
************* Home/away Team FE Results *******************					
	#delimit  ;
					esttab goal_diff_all_2 win_all_2 draw_all_2 home_points_all_2 using "$regressions/diff-in-diff/match_hfa_homeawayFE", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{H-A}\$" "Win" "Draw" "Points") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _) 
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR) 
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{l*{5}{c}}  \midrule ") 
							stats(season country controls homeaway N N_clust, 
							labels("Season FE" "League FE" "Controls" "Home*Away team FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
						#delimit cr	
					
					
		**** Second Table (Total and total xgoals)
				#delimit  ;
					esttab total_goals_all_2 total_xgoals_all_2 using "$regressions/diff-in-diff/match_total_homeawayFE", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{total}\$" "\$xG\_{total}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{l*{3}{c}}  \midrule ") 
							stats(season country controls homeaway N N_clust, 
							labels("Season FE" "League FE" "Controls" "Home*Away team FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr						

		
		
************* Ref FE Results *******************					
	#delimit  ;
					esttab goal_diff_all_3 win_all_3 draw_all_3 home_points_all_3 using "$regressions/diff-in-diff/match_hfa_refFE", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{H-A}\$" "Win" "Draw" "Points") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _) 
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR) 
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{l*{5}{c}}  \midrule ") 
							stats(season country controls homeaway N N_clust, 
							labels("Season FE" "League FE" "Controls" "Referee FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
						#delimit cr	
					
					
		**** Second Table (Total and total xgoals)
				#delimit  ;
					esttab total_goals_all_3 total_xgoals_all_3 using "$regressions/diff-in-diff/match_total_refFE", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{total}\$" "\$xG\_{total}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Baseline" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{l*{3}{c}}  \midrule ") 
							stats(season country controls ref N N_clust, 
							labels("Season FE" "League FE" "Controls" "Referee FE" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr						

		estimates clear			