/* ////////////////////////////////////////////////////////////////////////////////////////////////
Name: 			robustness_tables_RefStadiumFEs.do
Description: 	Analysis with ref and stadium FEs

Notes: 			- Created by Jeff
				- Last updated 2/6/2024
//////////////////////////////////////////////////////////////////////////////////////////////// */

* Set up environment ------------------------------------------------------------------------------
clear
set more off
version 16.0

*set scheme plotplainblind

*set processors 24
*set max_memory 115g

*Add in your file path with cap in front
cap cd "C:/Users/jcross/Dropbox/HFA and VAR"
cap cd "D:/Dropbox/HFA and VAR"
cap cd "C:\Users\uhrig_R\Dropbox\HFA and VAR"
cap cd "C:\Users\richa\Dropbox\HFA and VAR"
cap cd "C:\Users\camel\Dropbox\HFA and VAR"

* Raw data
global rawdata "1_data/0_raw"
global cleandata "1_data/1_clean"
global finaldata "1_data/2_final"

* Results
global graphs "4_results/Figures"
global regressions "4_results/Tables"

**************** Grab new data  *****************
	use "${finaldata}/final_treatment_wrefs_experience", clear
	

	**gen new variables to ease analysis
	egen countryXweek = group(country wk)
	encode country, gen(country_num)


	**drop Korea, who adopt VAR midseason in 2017
	drop if country == "korea"	
	drop if goal_diff == .
	
	encode referee_upper, gen(ref_num)
	
	egen homeaway = concat(home_team away_team)
	encode homeaway, gen(homeaway_num)

local loop "goal_diff win" /*goal_diff_xg win draw home_points total_goals total_xgoals" */
local controls "diff_points recent_points_diff_4 diff_prev_season_points"
	foreach l of local loop {
	
			if "`l'" == "goal_diff" {
				local dep = "Home Goals minus Away Goals"
			}
			/*
			if "`l'" == "goal_diff_xg" {
				local dep = "Home xGoals minus Away xGoals"
			}
			if "`l'" == "win" {
				local dep = "Pr(Win)"
			}
			if "`l'" == "draw" {
				local dep = "Pr(Draw)"
			}		
			if "`l'" == "home_points" {
				local dep = "Home Team Points per Game"
			}	
			if "`l'" == "total_goals" {
				local dep = "Goals per Game"
			}
			*/
/*
	reghdfe `l' VAR, noabsorb cluster(country) // 
					eststo `l'_none
					estadd local controls "No" , replace
					estadd local season "No" , replace
					estadd local country "No" , replace

	reghdfe `l' VAR, absorb(i.season i.country_num) cluster(country) // absorbs season and country
					eststo `l'_fixed
					estadd local controls "No" , replace
					estadd local season "Yes" , replace	
					estadd local country "Yes" , replace

					
	reghdfe `l' VAR `controls', noabsorb cluster(country) // controls for points diff
					eststo `l'_strength
					estadd local controls "Yes" , replace
					estadd local season "No" , replace
					estadd local country "No" , replace
*/
					
	reghdfe `l' VAR, absorb(i.season i.country_num) cluster(country) // controls for "form" and season/country
					eststo `l'_1
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					estadd local referee "No", replace
					estadd local home "No", replace
					estadd local controls "No" , replace
					estadd local homeaway "No", replace
					
	reghdfe `l' VAR, absorb(i.season i.country_num i.ref_num) cluster(country) // controls for "form" and season/country
					eststo `l'_2
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					estadd local referee "Yes", replace
					estadd local home "No", replace
					estadd local controls "No" , replace
					estadd local homeaway "No", replace
					
	reghdfe `l' VAR, absorb(i.season i.country_num i.ref_num i.team_list) cluster(country) // controls for "form" and season/country
					eststo `l'_3
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					estadd local referee "Yes", replace
					estadd local home "Yes", replace
					estadd local controls "No" , replace
					estadd local homeaway "No", replace
					
	reghdfe `l' VAR `controls', absorb(i.season i.country_num i.ref_num i.team_list) cluster(country) // controls for "form" and season/country
					eststo `l'_4
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					estadd local referee "Yes", replace
					estadd local home "Yes", replace
					estadd local controls "Yes" , replace
					estadd local homeaway "No", replace
					
	reghdfe `l' VAR `controls', absorb(i.season i.country_num i.ref_num i.homeaway_num) cluster(country) // controls for "form" and season/country
					eststo `l'_5
					estadd local season "Yes" , replace
					estadd local country "Yes" , replace
					estadd local referee "Yes", replace
					estadd local home "No", replace
					estadd local controls "Yes" , replace
					estadd local homeaway "Yes", replace
								
										
			
		}
		
		
		
		**** Main Table (home-away goals)
				#delimit  ;
					esttab goal_diff_1 goal_diff_2 goal_diff_3 goal_diff_4 goal_diff_5 using "$regressions/diff-in-diff/robustness_ref_home_FEs", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$" "\$G\_{H-A}\$") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Constant" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country referee home homeaway controls N N_clust, 
							labels("Season FE" "League FE" "Referee FE" "Home Team FE" "Home*Away Team FE" "Team Quality Controls" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
					
					
		**** Main Table (home-away goals)
				#delimit  ;
					esttab win_1 win_2 win_3 win_4 win_5 using "$regressions/diff-in-diff/robustness_win_ref_home_FEs", 
							b(3) se booktabs star(* .1 ** .05 *** .01) mtitles("Win" "Win" "Win" "Win" "Win") nonotes brackets replace label style(tex) gaps 
							keep(_cons VAR) substitute(\_ _)
							coef(_cons "Constant" VAR "VAR") order(_cons VAR)
							prehead("{\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi} \begin{tabular}{@{\extracolsep{2pt}}l*{8} 
							{>{\centering\arraybackslash}m{2cm}}@{}}  \midrule 
							 ") 
							stats(season country referee home homeaway controls N N_clust, 
							labels("Season FE" "League FE" "Referee FE" "Home Team FE" "Home*Away Team FE" "Team Quality Controls" "Observations" "Clusters") 
							fmt(%9.0fc %9.0fc));
					#delimit cr	
		